﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Text;
using System.Threading;

using KONICAMINOLTA.OpenAPISDK.SequenceAuthLibrary;
using KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.DeviceSettingNS;

namespace OpenAPI_App_Manager
{
    public class Result
    {
        public bool Success;
        public string Error;

        public Result()
        {
            this.Success = true;
            this.Error = string.Empty;
        }

        public Result(string Error)
        {
            this.Success = false;
            this.Error = Error;
        }
    }

    public class MFPConfig
    {
        private static string szSep;
        private static int GetMajor(double val)
        {
            string szVal = val.ToString();
            string szMajor;
            if (szVal.Contains(szSep))
                szVal = szVal.Replace(szSep, ".");
            if (szVal.Contains("."))
                szMajor = szVal.Substring(0, szVal.IndexOf("."));
            else
                szMajor = szVal;

            return int.Parse(szMajor);
        }
        private static int GetMinor(double val)
        {
            string szVal = val.ToString();
            string szMinor;
            if (szVal.Contains(szSep))
                szVal = szVal.Replace(szSep, ".");
            if (szVal.Contains("."))
                szMinor = szVal.Substring(szVal.IndexOf(".") + 1);
            else
                szMinor = "0";

            return int.Parse(szMinor);
        }

        public class FV
        {
            public class FuncVer
            {
                public double Highest;
                public List<double> List;
                public int Major
                {
                    get
                    {
                        return GetMajor(Highest);
                    }
                }
                public int Minor
                {
                    get
                    {
                        return GetMinor(Highest);
                    }
                }

                public FuncVer()
                {
                    Highest = 0.0;
                    List = new List<double>();
                }

                public string ToStringList()
                {
                    this.List.Sort();
                    string szRet = string.Empty;
                    foreach (double d in this.List)
                    {
                        string szThis = d.ToString(CultureInfo.InvariantCulture);
                        if (!szThis.Contains("."))
                            szThis += ".0";
                        szRet += szThis + ", ";
                    }
                    if (szRet.EndsWith(", "))
                        szRet = szRet.Substring(0, szRet.Length - 2);
                    if (szRet == string.Empty)
                        szRet = "N/A";
                    return szRet;
                }
            }

            public FuncVer Setup = new FuncVer();
            public FuncVer PullPrint = new FuncVer();
            public FuncVer Scan = new FuncVer();
            public FuncVer Authentication = new FuncVer();
            public FuncVer OtherA = new FuncVer();
            public FuncVer ScreenSaver = new FuncVer();
            public FuncVer BrowserLauncher = new FuncVer();
            public FuncVer AuthenticationWithBrowser = new FuncVer();
            public FuncVer ScanWithBrowser = new FuncVer();
            public FuncVer PullPrintWithBrowser = new FuncVer();
            public FuncVer JobManagement = new FuncVer();
            public FuncVer BrowserGeneral = new FuncVer();
        }

        public string Address;
        public string Password;
        public string OpenAPIUsername;
        public string OpenAPIPassword;
        public string Model;
        public string DisplayModel;
        public string MACAddress;
        public bool ColourPrint;
        public bool ColourScan;

        public FV FunctionVersion;
        public bool SSL;
        public int Port;
        public bool OpenAPIEnabled;

        public MFPConfig()
        {
            OpenAPIEnabled = false;
            Port = 0;
            SSL = false;
            DisplayModel = "Unknown";
            Model = "Unknown";
            MACAddress = "Unknown";           //Exists for search to populate it - QueryMFP doesn't
            Password = "12345678";            //MFP Default
            OpenAPIUsername = string.Empty;   //MFP Default
            OpenAPIPassword = string.Empty;   //MFP Default
            FunctionVersion = new FV();
            ColourPrint = false;
            ColourScan = false;
            szSep = CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator;
        }

        public Result QueryMFP()
        {
            Result result = new Result();
            
            KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.DeviceDescriptionManager DeviceDescriptionMain = new KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.DeviceDescriptionManager();
            KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.DeviceDescriptionSettingNS.DeviceDescriptionSetting setting = new KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.DeviceDescriptionSettingNS.DeviceDescriptionSetting();
            setting.IPAddress = Address;
            KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.DeviceDescriptionNS.DeviceDescription devMFP = new KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.DeviceDescriptionNS.DeviceDescription();
            
            
            try
            {
                KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.ResultStatusNS.ResultStatus ret;
                try
                {
                    ret = DeviceDescriptionMain.GetDeviceDescription(setting, ref devMFP);

                    //if (devMFP.Configuration.SupportVersionList != null &&
                    //       devMFP.Configuration.SupportVersionList.SupportVersion != null)
                    //{
                    //    KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.DeviceDescriptionNS.OpenApiVersion latestVersion
                    //        = new KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.DeviceDescriptionNS.OpenApiVersion();
                    //    latestVersion.ProtocolVersion = new KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.DeviceDescriptionNS.ProtocolVersion();
                    //    latestVersion.ProtocolVersion.Major = 0;
                    //    latestVersion.ProtocolVersion.Minor = 0;
                    //    foreach (KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.DeviceDescriptionNS.SupportVersion version
                    //        in devMFP.Configuration.SupportVersionList.SupportVersion)
                    //    {
                    //        if (latestVersion.ProtocolVersion.Major < version.OpenApiVersion.ProtocolVersion.Major ||
                    //            (latestVersion.ProtocolVersion.Major == version.OpenApiVersion.ProtocolVersion.Major &&
                    //            latestVersion.ProtocolVersion.Minor < version.OpenApiVersion.ProtocolVersion.Minor))
                    //        {
                    //            latestVersion = version.OpenApiVersion;
                    //        }
                    //    }
                    //}
                }
                catch
                {
                    //Try again on exception (such as web exception) caused by weird DNS attempt issue
                    Thread.Sleep(500);
                    ret = DeviceDescriptionMain.GetDeviceDescription(setting, ref devMFP);
                }
                if (ret.ResultStatusInfo != "1")
                {
                    try
                    {
                        ret = DeviceDescriptionMain.GetDeviceDescription(setting, ref devMFP); //Try again!
                    }
                    catch (Exception ex)
                    {
                        ret = new KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.ResultStatusNS.ResultStatus();
                        ret.Error = new KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.ResultStatusNS.Error();
                        ret.ResultStatusInfo = "2";
                        ret.Error.Code = ex.Message;
                    }
                }

                if (ret.ResultStatusInfo == "1")
                {
                    OpenAPIEnabled = (devMFP.Configuration.OpenApiConfiguration.Type == "On");
                    Port = devMFP.Configuration.OpenApiConfiguration.PortNo;
                    SSL = devMFP.Configuration.OpenApiConfiguration.Ssl;
                    Model = devMFP.Configuration.DeviceConfiguration.ProductName;
                    DisplayModel = Model;
                    if (DisplayModel.ToUpper().StartsWith("KONICA MINOLTA"))
                        DisplayModel = DisplayModel.Substring("KONICA MINOLTA".Length);
                    DisplayModel = DisplayModel.Trim();

                    ColourPrint = devMFP.Configuration.DeviceConfiguration.Color.Printer;
                    ColourScan = devMFP.Configuration.DeviceConfiguration.Color.Scanner;

                    if (devMFP.External != null) //Our supported Functions and their FunctionVersions
                    {
                        if (int.Parse(devMFP.External.FunctionInfoList.ArraySize) > 0)
                        {
                            foreach (KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.DeviceDescriptionNS.FunctionInfo func in devMFP.External.FunctionInfoList.FunctionInfo)
                            {
                                #region Scan to Application with JobTicket
                                if (func.FunctionName == "Scan to Application with JobTicket")
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);
                                        if (FunctionVersion.Scan.List.Count == 0)
                                            FunctionVersion.Scan.Highest = dThisVer;

                                        if (!FunctionVersion.Scan.List.Contains(dThisVer))
                                            FunctionVersion.Scan.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.Scan.Highest)
                                            FunctionVersion.Scan.Highest = dThisVer;
                                    }
                                    catch { }
                                }
                                #endregion
                                #region PullPrint
                                else if (func.FunctionName == "PullPrint")
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);

                                        if (FunctionVersion.PullPrint.List.Count == 0)
                                            FunctionVersion.PullPrint.Highest = dThisVer;

                                        if (!FunctionVersion.PullPrint.List.Contains(dThisVer))
                                            FunctionVersion.PullPrint.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.PullPrint.Highest)
                                            FunctionVersion.PullPrint.Highest = dThisVer;

                                    }
                                    catch { }
                                }
                                #endregion
                                #region Authentication
                                else if (func.FunctionName == "Authentication")
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);

                                        if (FunctionVersion.Authentication.List.Count == 0)
                                            FunctionVersion.Authentication.Highest = dThisVer;

                                        if (!FunctionVersion.Authentication.List.Contains(dThisVer))
                                            FunctionVersion.Authentication.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.Authentication.Highest)
                                            FunctionVersion.Authentication.Highest = dThisVer;
                                    }
                                    catch { }
                                }
                                #endregion
                                #region OtherA
                                else if (func.FunctionName == "OtherA")
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);

                                        if (FunctionVersion.OtherA.List.Count == 0)
                                            FunctionVersion.OtherA.Highest = dThisVer;

                                        if (!FunctionVersion.OtherA.List.Contains(dThisVer))
                                            FunctionVersion.OtherA.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.OtherA.Highest)
                                            FunctionVersion.OtherA.Highest = dThisVer;
                                    }
                                    catch { }
                                }
                                #endregion
                                #region Setup
                                else if (func.FunctionName == "Setup")
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);

                                        if (FunctionVersion.Setup.List.Count == 0)
                                            FunctionVersion.Setup.Highest = dThisVer;

                                        if (!FunctionVersion.Setup.List.Contains(dThisVer))
                                            FunctionVersion.Setup.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.Setup.Highest)
                                            FunctionVersion.Setup.Highest = dThisVer;
                                    }
                                    catch { }
                                }
                                #endregion
                                #region Scan to Application with Browser
                                else if (func.FunctionName == "Scan to Application with Browser")
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);

                                        if (FunctionVersion.ScanWithBrowser.List.Count == 0)
                                            FunctionVersion.ScanWithBrowser.Highest = dThisVer;

                                        if (!FunctionVersion.ScanWithBrowser.List.Contains(dThisVer))
                                            FunctionVersion.ScanWithBrowser.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.ScanWithBrowser.Highest)
                                            FunctionVersion.ScanWithBrowser.Highest = dThisVer;
                                    }
                                    catch { }
                                }
                                #endregion
                                #region PullPrint with Browser
                                else if (func.FunctionName == "PullPrint with Browser")
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);

                                        if (FunctionVersion.PullPrintWithBrowser.List.Count == 0)
                                            FunctionVersion.PullPrintWithBrowser.Highest = dThisVer;

                                        if (!FunctionVersion.PullPrintWithBrowser.List.Contains(dThisVer))
                                            FunctionVersion.PullPrintWithBrowser.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.PullPrintWithBrowser.Highest)
                                            FunctionVersion.PullPrintWithBrowser.Highest = dThisVer;
                                    }
                                    catch { }
                                }
                                #endregion
                                #region Authentication with Browser
                                else if (func.FunctionName == "Authentication with Browser")
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);

                                        if (FunctionVersion.AuthenticationWithBrowser.List.Count == 0)
                                            FunctionVersion.AuthenticationWithBrowser.Highest = dThisVer;

                                        if (!FunctionVersion.AuthenticationWithBrowser.List.Contains(dThisVer))
                                            FunctionVersion.AuthenticationWithBrowser.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.AuthenticationWithBrowser.Highest)
                                            FunctionVersion.AuthenticationWithBrowser.Highest = dThisVer;
                                    }
                                    catch { }
                                }
                                #endregion
                                #region Browser Launcher
                                else if (func.FunctionName == "Browser Launcher")
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);

                                        if (FunctionVersion.BrowserLauncher.List.Count == 0)
                                            FunctionVersion.BrowserLauncher.Highest = dThisVer;

                                        if (!FunctionVersion.BrowserLauncher.List.Contains(dThisVer))
                                            FunctionVersion.BrowserLauncher.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.BrowserLauncher.Highest)
                                            FunctionVersion.BrowserLauncher.Highest = dThisVer;
                                    }
                                    catch { }
                                }
                                #endregion
                                #region Screensaver
                                else if (func.FunctionName == "ScreenSaver")
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);

                                        if (FunctionVersion.ScreenSaver.List.Count == 0)
                                            FunctionVersion.ScreenSaver.Highest = dThisVer;

                                        if (!FunctionVersion.ScreenSaver.List.Contains(dThisVer))
                                            FunctionVersion.ScreenSaver.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.ScreenSaver.Highest)
                                            FunctionVersion.ScreenSaver.Highest = dThisVer;
                                    }
                                    catch { }
                                }
                                #endregion
                                #region JobManagement
                                else if (func.FunctionName == "JobManegement") //(sic)
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);

                                        if (FunctionVersion.JobManagement.List.Count == 0)
                                            FunctionVersion.JobManagement.Highest = dThisVer;

                                        if (!FunctionVersion.JobManagement.List.Contains(dThisVer))
                                            FunctionVersion.JobManagement.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.JobManagement.Highest)
                                            FunctionVersion.JobManagement.Highest = dThisVer;
                                    }
                                    catch { }
                                }
                                #endregion
                                #region General Browser
                                else if (func.FunctionName == "BrowserGeneral")
                                {
                                    try
                                    {
                                        double dThisVer = double.Parse(func.FunctionVersion.Major.ToString() + "." + func.FunctionVersion.Minor.ToString(), CultureInfo.InvariantCulture);

                                        if (FunctionVersion.BrowserGeneral.List.Count == 0)
                                            FunctionVersion.BrowserGeneral.Highest = dThisVer;

                                        if (!FunctionVersion.BrowserGeneral.List.Contains(dThisVer))
                                            FunctionVersion.BrowserGeneral.List.Add(dThisVer);

                                        if (dThisVer > FunctionVersion.BrowserGeneral.Highest)
                                            FunctionVersion.BrowserGeneral.Highest = dThisVer;
                                    }
                                    catch { }
                                }
                                #endregion
                                else
                                {
                                    //Unknown function type - ignore
                                }
                            }
                        }
                    }
                }
                else
                {
                    //ResultInfo = "2"
                    if (!string.IsNullOrEmpty(ret.Error.Code))
                        result = new Result(ret.Error.Code);
                    else
                        result = new Result("Undefined error");
                }
            }
            catch (Exception ex)
            {
                //Probably failed to communicate with MFP
                result = new Result(ex.Message);
            }

            return result;
        }

        public override string ToString()
        {
            return Address + " (" + DisplayModel + ")";
        }
    }

    public class AuthAppDetails
    {
        public bool Exists;
        public string AppName;
        public bool BrowserAuth;
        public int FunctionVersionMajor;
        public int FunctionVersionMinor;
        public int AppNumber;

        public AuthAppDetails()
        {
            this.Exists = false;
            this.AppName = string.Empty;
            this.BrowserAuth = false;
            this.FunctionVersionMajor = 0;
            this.FunctionVersionMinor = 0;
            this.AppNumber = 0;
        }
    }

    public class AuthSettings
    {
        public enum PublicAuthMode { Off, On, OnByDefault }

        public bool Enable;
        public bool BoxAdmin;
        public PublicAuthMode PublicMode;
        public FunctionLimitationSetting PublicUserLimits;
        public bool AdminMayEdit;

        public AuthSettings(bool Enable, bool BoxAdmin, PublicAuthMode PublicMode, FunctionLimitationSetting PublicUserLimits, bool AdminMayEdit)
        {
            this.Enable = Enable;
            this.BoxAdmin = BoxAdmin;
            this.PublicMode = PublicMode;
            this.PublicUserLimits = PublicUserLimits;
            this.AdminMayEdit = AdminMayEdit;
        }
    }

    public class AdvancedSearchSettings
    {
        public bool FunctionVersion;
        public string FunctionVersionAppType;
        public string FunctionVersionAppVersion;
        public bool Application;
        public string ApplicationName;
        public bool ProductName;
        public string ProductNameText;
        public bool SSLSetting;
        public string SSLText;
        public string FunctionVersionOperator;
        public string FunctionVersionAppVersion1;
        public bool ColorSetting;
        public string ColorText;
        public AdvancedSearchSettings()
        {
            this.FunctionVersion = false;
            this.FunctionVersionAppType = "Setup";
            this.FunctionVersionAppVersion = "1.0";
            this.Application = false;
            this.ApplicationName = string.Empty;
            this.ProductName = false;
            this.ProductNameText = string.Empty;
            this.SSLSetting = false;
            this.SSLText = "True";
            this.FunctionVersionOperator = "Has";
            this.ColorSetting = false;
            this.ColorText = "Monochrome";
        }
    }

    public class AppSettings
    {
        public List<MFPConfig> MFPList;
        public SearchSettings Search;
        public AdvancedSearchSettings AdvancedSearch;

        public class SearchSettings
        {
            public int SNMPVersion;
            public string SearchMethod;
            public string SNMPv3Username;
            public string SNMPv3Context;
            public string SNMPv1Community;

            public string SNMPBroadcastAddress;
            public string SNMPPingStartAddress;
            public string SNMPPingEndAddress;

            public SearchSettings()
            {
                SNMPVersion = 1;
                SearchMethod = "UPnP";
                SNMPv3Username = "user";
                SNMPv3Context = "unknown";
                SNMPv1Community = "public";
                SNMPBroadcastAddress = "255.255.255.255";
                SNMPPingStartAddress = string.Empty;
                SNMPPingEndAddress = string.Empty;
            }
        }

        public AppSettings()
        {
            MFPList = new List<MFPConfig>();
            Search = new SearchSettings();
            AdvancedSearch = new AdvancedSearchSettings();
        }
    }
}
